// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of the storage task assignment.
 */
@Fluent
public final class StorageTaskAssignmentProperties {
    /*
     * Id of the corresponding storage task
     */
    @JsonProperty(value = "taskId", required = true)
    private String taskId;

    /*
     * Whether the storage task assignment is enabled or not
     */
    @JsonProperty(value = "enabled", required = true)
    private boolean enabled;

    /*
     * Text that describes the purpose of the storage task assignment
     */
    @JsonProperty(value = "description", required = true)
    private String description;

    /*
     * The storage task assignment execution context
     */
    @JsonProperty(value = "executionContext", required = true)
    private StorageTaskAssignmentExecutionContext executionContext;

    /*
     * The storage task assignment report
     */
    @JsonProperty(value = "report", required = true)
    private StorageTaskAssignmentReport report;

    /*
     * Represents the provisioning state of the storage task assignment.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * Run status of storage task assignment
     */
    @JsonProperty(value = "runStatus")
    private StorageTaskReportProperties runStatus;

    /**
     * Creates an instance of StorageTaskAssignmentProperties class.
     */
    public StorageTaskAssignmentProperties() {
    }

    /**
     * Get the taskId property: Id of the corresponding storage task.
     * 
     * @return the taskId value.
     */
    public String taskId() {
        return this.taskId;
    }

    /**
     * Set the taskId property: Id of the corresponding storage task.
     * 
     * @param taskId the taskId value to set.
     * @return the StorageTaskAssignmentProperties object itself.
     */
    public StorageTaskAssignmentProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    /**
     * Get the enabled property: Whether the storage task assignment is enabled or not.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether the storage task assignment is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the StorageTaskAssignmentProperties object itself.
     */
    public StorageTaskAssignmentProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the description property: Text that describes the purpose of the storage task assignment.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Text that describes the purpose of the storage task assignment.
     * 
     * @param description the description value to set.
     * @return the StorageTaskAssignmentProperties object itself.
     */
    public StorageTaskAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the executionContext property: The storage task assignment execution context.
     * 
     * @return the executionContext value.
     */
    public StorageTaskAssignmentExecutionContext executionContext() {
        return this.executionContext;
    }

    /**
     * Set the executionContext property: The storage task assignment execution context.
     * 
     * @param executionContext the executionContext value to set.
     * @return the StorageTaskAssignmentProperties object itself.
     */
    public StorageTaskAssignmentProperties
        withExecutionContext(StorageTaskAssignmentExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    /**
     * Get the report property: The storage task assignment report.
     * 
     * @return the report value.
     */
    public StorageTaskAssignmentReport report() {
        return this.report;
    }

    /**
     * Set the report property: The storage task assignment report.
     * 
     * @param report the report value to set.
     * @return the StorageTaskAssignmentProperties object itself.
     */
    public StorageTaskAssignmentProperties withReport(StorageTaskAssignmentReport report) {
        this.report = report;
        return this;
    }

    /**
     * Get the provisioningState property: Represents the provisioning state of the storage task assignment.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the runStatus property: Run status of storage task assignment.
     * 
     * @return the runStatus value.
     */
    public StorageTaskReportProperties runStatus() {
        return this.runStatus;
    }

    /**
     * Set the runStatus property: Run status of storage task assignment.
     * 
     * @param runStatus the runStatus value to set.
     * @return the StorageTaskAssignmentProperties object itself.
     */
    public StorageTaskAssignmentProperties withRunStatus(StorageTaskReportProperties runStatus) {
        this.runStatus = runStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (taskId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property taskId in model StorageTaskAssignmentProperties"));
        }
        if (description() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property description in model StorageTaskAssignmentProperties"));
        }
        if (executionContext() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property executionContext in model StorageTaskAssignmentProperties"));
        } else {
            executionContext().validate();
        }
        if (report() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property report in model StorageTaskAssignmentProperties"));
        } else {
            report().validate();
        }
        if (runStatus() != null) {
            runStatus().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentProperties.class);
}
