// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The SignedIdentifier model.
 */
@Fluent
public final class SignedIdentifier {
    /*
     * An unique identifier of the stored access policy.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * Access policy
     */
    @JsonProperty(value = "accessPolicy")
    private AccessPolicy accessPolicy;

    /**
     * Creates an instance of SignedIdentifier class.
     */
    public SignedIdentifier() {
    }

    /**
     * Get the id property: An unique identifier of the stored access policy.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: An unique identifier of the stored access policy.
     * 
     * @param id the id value to set.
     * @return the SignedIdentifier object itself.
     */
    public SignedIdentifier withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the accessPolicy property: Access policy.
     * 
     * @return the accessPolicy value.
     */
    public AccessPolicy accessPolicy() {
        return this.accessPolicy;
    }

    /**
     * Set the accessPolicy property: Access policy.
     * 
     * @param accessPolicy the accessPolicy value to set.
     * @return the SignedIdentifier object itself.
     */
    public SignedIdentifier withAccessPolicy(AccessPolicy accessPolicy) {
        this.accessPolicy = accessPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accessPolicy() != null) {
            accessPolicy().validate();
        }
    }
}
