// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes provisioning issue for given NetworkSecurityPerimeterConfiguration.
 */
@Fluent
public final class ProvisioningIssue {
    /*
     * Name of the issue
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Properties of provisioning issue
     */
    @JsonProperty(value = "properties", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningIssueProperties properties;

    /**
     * Creates an instance of ProvisioningIssue class.
     */
    public ProvisioningIssue() {
    }

    /**
     * Get the name property: Name of the issue.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the issue.
     * 
     * @param name the name value to set.
     * @return the ProvisioningIssue object itself.
     */
    public ProvisioningIssue withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the properties property: Properties of provisioning issue.
     * 
     * @return the properties value.
     */
    public ProvisioningIssueProperties properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
