// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Information about resource association.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation {
    /*
     * Name of the resource association
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Access Mode of the resource association
     */
    @JsonProperty(value = "accessMode")
    private ResourceAssociationAccessMode accessMode;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation class.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation() {
    }

    /**
     * Get the name property: Name of the resource association.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource association.
     * 
     * @param name the name value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the accessMode property: Access Mode of the resource association.
     * 
     * @return the accessMode value.
     */
    public ResourceAssociationAccessMode accessMode() {
        return this.accessMode;
    }

    /**
     * Set the accessMode property: Access Mode of the resource association.
     * 
     * @param accessMode the accessMode value to set.
     * @return the NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation object itself.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation
        withAccessMode(ResourceAssociationAccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
