// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.storage.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Result of the List Network Security Perimeter configuration operation.
 */
@Fluent
public final class NetworkSecurityPerimeterConfigurationList {
    /*
     * A collection of Network Security Perimeter configurations
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<NetworkSecurityPerimeterConfigurationInner> value;

    /*
     * The URI that can be used to request the next set of paged results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationList class.
     */
    public NetworkSecurityPerimeterConfigurationList() {
    }

    /**
     * Get the value property: A collection of Network Security Perimeter configurations.
     * 
     * @return the value value.
     */
    public List<NetworkSecurityPerimeterConfigurationInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NetworkSecurityPerimeterConfigurationList object itself.
     */
    public NetworkSecurityPerimeterConfigurationList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
