// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active
 * and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location
 * is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary
 * location is temporarily unavailable.
 */
public final class GeoReplicationStatus extends ExpandableStringEnum<GeoReplicationStatus> {
    /**
     * Static value Live for GeoReplicationStatus.
     */
    public static final GeoReplicationStatus LIVE = fromString("Live");

    /**
     * Static value Bootstrap for GeoReplicationStatus.
     */
    public static final GeoReplicationStatus BOOTSTRAP = fromString("Bootstrap");

    /**
     * Static value Unavailable for GeoReplicationStatus.
     */
    public static final GeoReplicationStatus UNAVAILABLE = fromString("Unavailable");

    /**
     * Creates a new instance of GeoReplicationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GeoReplicationStatus() {
    }

    /**
     * Creates or finds a GeoReplicationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GeoReplicationStatus.
     */
    @JsonCreator
    public static GeoReplicationStatus fromString(String name) {
        return fromString(name, GeoReplicationStatus.class);
    }

    /**
     * Gets known GeoReplicationStatus values.
     * 
     * @return known GeoReplicationStatus values.
     */
    public static Collection<GeoReplicationStatus> values() {
        return values(GeoReplicationStatus.class);
    }
}
