// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Execution trigger for storage task assignment.
 */
@Fluent
public final class ExecutionTrigger {
    /*
     * The trigger type of the storage task assignment execution
     */
    @JsonProperty(value = "type", required = true)
    private TriggerType type;

    /*
     * The trigger parameters of the storage task assignment execution
     */
    @JsonProperty(value = "parameters", required = true)
    private TriggerParameters parameters;

    /**
     * Creates an instance of ExecutionTrigger class.
     */
    public ExecutionTrigger() {
    }

    /**
     * Get the type property: The trigger type of the storage task assignment execution.
     * 
     * @return the type value.
     */
    public TriggerType type() {
        return this.type;
    }

    /**
     * Set the type property: The trigger type of the storage task assignment execution.
     * 
     * @param type the type value to set.
     * @return the ExecutionTrigger object itself.
     */
    public ExecutionTrigger withType(TriggerType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the parameters property: The trigger parameters of the storage task assignment execution.
     * 
     * @return the parameters value.
     */
    public TriggerParameters parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The trigger parameters of the storage task assignment execution.
     * 
     * @param parameters the parameters value to set.
     * @return the ExecutionTrigger object itself.
     */
    public ExecutionTrigger withParameters(TriggerParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ExecutionTrigger"));
        }
        if (parameters() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property parameters in model ExecutionTrigger"));
        } else {
            parameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExecutionTrigger.class);
}
