// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The storage task assignment.
 */
@Fluent
public final class StorageTaskAssignmentInner extends ProxyResource {
    /*
     * Properties of the storage task assignment.
     */
    @JsonProperty(value = "properties", required = true)
    private StorageTaskAssignmentProperties properties;

    /**
     * Creates an instance of StorageTaskAssignmentInner class.
     */
    public StorageTaskAssignmentInner() {
    }

    /**
     * Get the properties property: Properties of the storage task assignment.
     * 
     * @return the properties value.
     */
    public StorageTaskAssignmentProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the storage task assignment.
     * 
     * @param properties the properties value to set.
     * @return the StorageTaskAssignmentInner object itself.
     */
    public StorageTaskAssignmentInner withProperties(StorageTaskAssignmentProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property properties in model StorageTaskAssignmentInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentInner.class);
}
