// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.storage.models.CorsRules;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties of a storage account’s Queue service.
 */
@Fluent
public final class QueueServicePropertiesInner extends ProxyResource {
    /*
     * The properties of a storage account’s Queue service.
     */
    @JsonProperty(value = "properties")
    private QueueServicePropertiesProperties innerQueueServiceProperties;

    /**
     * Creates an instance of QueueServicePropertiesInner class.
     */
    public QueueServicePropertiesInner() {
    }

    /**
     * Get the innerQueueServiceProperties property: The properties of a storage account’s Queue service.
     * 
     * @return the innerQueueServiceProperties value.
     */
    private QueueServicePropertiesProperties innerQueueServiceProperties() {
        return this.innerQueueServiceProperties;
    }

    /**
     * Get the cors property: Specifies CORS rules for the Queue service. You can include up to five CorsRule elements
     * in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and
     * CORS will be disabled for the Queue service.
     * 
     * @return the cors value.
     */
    public CorsRules cors() {
        return this.innerQueueServiceProperties() == null ? null : this.innerQueueServiceProperties().cors();
    }

    /**
     * Set the cors property: Specifies CORS rules for the Queue service. You can include up to five CorsRule elements
     * in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and
     * CORS will be disabled for the Queue service.
     * 
     * @param cors the cors value to set.
     * @return the QueueServicePropertiesInner object itself.
     */
    public QueueServicePropertiesInner withCors(CorsRules cors) {
        if (this.innerQueueServiceProperties() == null) {
            this.innerQueueServiceProperties = new QueueServicePropertiesProperties();
        }
        this.innerQueueServiceProperties().withCors(cors);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerQueueServiceProperties() != null) {
            innerQueueServiceProperties().validate();
        }
    }
}
