// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * The trigger parameters update for the storage task assignment execution.
 */
@Fluent
public final class TriggerParametersUpdate {
    /*
     * When to start task execution. This is a mutable field when ExecutionTrigger.properties.type is 'OnSchedule'; this
     * property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JsonProperty(value = "startFrom")
    private OffsetDateTime startFrom;

    /*
     * Run interval of task execution. This is a mutable field when ExecutionTrigger.properties.type is 'OnSchedule';
     * this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JsonProperty(value = "interval")
    private Integer interval;

    /*
     * Run interval unit of task execution. This is a mutable field when ExecutionTrigger.properties.type is
     * 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JsonProperty(value = "intervalUnit")
    private IntervalUnit intervalUnit;

    /*
     * When to end task execution. This is a mutable field when ExecutionTrigger.properties.type is 'OnSchedule'; this
     * property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
     */
    @JsonProperty(value = "endBy")
    private OffsetDateTime endBy;

    /*
     * When to start task execution. This is a mutable field when ExecutionTrigger.properties.type is 'RunOnce'; this
     * property should not be present when ExecutionTrigger.properties.type is 'OnSchedule'
     */
    @JsonProperty(value = "startOn")
    private OffsetDateTime startOn;

    /**
     * Creates an instance of TriggerParametersUpdate class.
     */
    public TriggerParametersUpdate() {
    }

    /**
     * Get the startFrom property: When to start task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when
     * ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @return the startFrom value.
     */
    public OffsetDateTime startFrom() {
        return this.startFrom;
    }

    /**
     * Set the startFrom property: When to start task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when
     * ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @param startFrom the startFrom value to set.
     * @return the TriggerParametersUpdate object itself.
     */
    public TriggerParametersUpdate withStartFrom(OffsetDateTime startFrom) {
        this.startFrom = startFrom;
        return this;
    }

    /**
     * Get the interval property: Run interval of task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when
     * ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @return the interval value.
     */
    public Integer interval() {
        return this.interval;
    }

    /**
     * Set the interval property: Run interval of task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when
     * ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @param interval the interval value to set.
     * @return the TriggerParametersUpdate object itself.
     */
    public TriggerParametersUpdate withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the intervalUnit property: Run interval unit of task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when
     * ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @return the intervalUnit value.
     */
    public IntervalUnit intervalUnit() {
        return this.intervalUnit;
    }

    /**
     * Set the intervalUnit property: Run interval unit of task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when
     * ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @param intervalUnit the intervalUnit value to set.
     * @return the TriggerParametersUpdate object itself.
     */
    public TriggerParametersUpdate withIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
        return this;
    }

    /**
     * Get the endBy property: When to end task execution. This is a mutable field when ExecutionTrigger.properties.type
     * is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @return the endBy value.
     */
    public OffsetDateTime endBy() {
        return this.endBy;
    }

    /**
     * Set the endBy property: When to end task execution. This is a mutable field when ExecutionTrigger.properties.type
     * is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'.
     * 
     * @param endBy the endBy value to set.
     * @return the TriggerParametersUpdate object itself.
     */
    public TriggerParametersUpdate withEndBy(OffsetDateTime endBy) {
        this.endBy = endBy;
        return this;
    }

    /**
     * Get the startOn property: When to start task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'RunOnce'; this property should not be present when
     * ExecutionTrigger.properties.type is 'OnSchedule'.
     * 
     * @return the startOn value.
     */
    public OffsetDateTime startOn() {
        return this.startOn;
    }

    /**
     * Set the startOn property: When to start task execution. This is a mutable field when
     * ExecutionTrigger.properties.type is 'RunOnce'; this property should not be present when
     * ExecutionTrigger.properties.type is 'OnSchedule'.
     * 
     * @param startOn the startOn value to set.
     * @return the TriggerParametersUpdate object itself.
     */
    public TriggerParametersUpdate withStartOn(OffsetDateTime startOn) {
        this.startOn = startOn;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
