// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters of the storage task assignment update request.
 */
@Fluent
public final class StorageTaskAssignmentUpdateParameters {
    /*
     * Properties of the storage task assignment.
     */
    @JsonProperty(value = "properties")
    private StorageTaskAssignmentUpdateProperties properties;

    /**
     * Creates an instance of StorageTaskAssignmentUpdateParameters class.
     */
    public StorageTaskAssignmentUpdateParameters() {
    }

    /**
     * Get the properties property: Properties of the storage task assignment.
     * 
     * @return the properties value.
     */
    public StorageTaskAssignmentUpdateProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of the storage task assignment.
     * 
     * @param properties the properties value to set.
     * @return the StorageTaskAssignmentUpdateParameters object itself.
     */
    public StorageTaskAssignmentUpdateParameters withProperties(StorageTaskAssignmentUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
