// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The storage task assignment report.
 */
@Fluent
public final class StorageTaskAssignmentReport {
    /*
     * The container prefix for the location of storage task assignment report
     */
    @JsonProperty(value = "prefix", required = true)
    private String prefix;

    /**
     * Creates an instance of StorageTaskAssignmentReport class.
     */
    public StorageTaskAssignmentReport() {
    }

    /**
     * Get the prefix property: The container prefix for the location of storage task assignment report.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The container prefix for the location of storage task assignment report.
     * 
     * @param prefix the prefix value to set.
     * @return the StorageTaskAssignmentReport object itself.
     */
    public StorageTaskAssignmentReport withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (prefix() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property prefix in model StorageTaskAssignmentReport"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentReport.class);
}
