// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Represents the status of the execution.
 */
public final class RunStatusEnum extends ExpandableStringEnum<RunStatusEnum> {
    /**
     * Static value InProgress for RunStatusEnum.
     */
    public static final RunStatusEnum IN_PROGRESS = fromString("InProgress");

    /**
     * Static value Finished for RunStatusEnum.
     */
    public static final RunStatusEnum FINISHED = fromString("Finished");

    /**
     * Creates a new instance of RunStatusEnum value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RunStatusEnum() {
    }

    /**
     * Creates or finds a RunStatusEnum from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RunStatusEnum.
     */
    @JsonCreator
    public static RunStatusEnum fromString(String name) {
        return fromString(name, RunStatusEnum.class);
    }

    /**
     * Gets known RunStatusEnum values.
     * 
     * @return known RunStatusEnum values.
     */
    public static Collection<RunStatusEnum> values() {
        return values(RunStatusEnum.class);
    }
}
