// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Properties of provisioning issue.
 */
@Fluent
public final class ProvisioningIssueProperties {
    /*
     * Type of issue
     */
    @JsonProperty(value = "issueType")
    private IssueType issueType;

    /*
     * Severity of the issue.
     */
    @JsonProperty(value = "severity")
    private Severity severity;

    /*
     * Description of the issue
     */
    @JsonProperty(value = "description")
    private String description;

    /**
     * Creates an instance of ProvisioningIssueProperties class.
     */
    public ProvisioningIssueProperties() {
    }

    /**
     * Get the issueType property: Type of issue.
     * 
     * @return the issueType value.
     */
    public IssueType issueType() {
        return this.issueType;
    }

    /**
     * Set the issueType property: Type of issue.
     * 
     * @param issueType the issueType value to set.
     * @return the ProvisioningIssueProperties object itself.
     */
    public ProvisioningIssueProperties withIssueType(IssueType issueType) {
        this.issueType = issueType;
        return this;
    }

    /**
     * Get the severity property: Severity of the issue.
     * 
     * @return the severity value.
     */
    public Severity severity() {
        return this.severity;
    }

    /**
     * Set the severity property: Severity of the issue.
     * 
     * @param severity the severity value to set.
     * @return the ProvisioningIssueProperties object itself.
     */
    public ProvisioningIssueProperties withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    /**
     * Get the description property: Description of the issue.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the issue.
     * 
     * @param description the description value to set.
     * @return the ProvisioningIssueProperties object itself.
     */
    public ProvisioningIssueProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
