// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Provisioning state of Network Security Perimeter configuration propagation.
 */
public final class NetworkSecurityPerimeterConfigurationProvisioningState
    extends ExpandableStringEnum<NetworkSecurityPerimeterConfigurationProvisioningState> {
    /**
     * Static value Accepted for NetworkSecurityPerimeterConfigurationProvisioningState.
     */
    public static final NetworkSecurityPerimeterConfigurationProvisioningState ACCEPTED = fromString("Accepted");

    /**
     * Static value Succeeded for NetworkSecurityPerimeterConfigurationProvisioningState.
     */
    public static final NetworkSecurityPerimeterConfigurationProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for NetworkSecurityPerimeterConfigurationProvisioningState.
     */
    public static final NetworkSecurityPerimeterConfigurationProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Deleting for NetworkSecurityPerimeterConfigurationProvisioningState.
     */
    public static final NetworkSecurityPerimeterConfigurationProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Canceled for NetworkSecurityPerimeterConfigurationProvisioningState.
     */
    public static final NetworkSecurityPerimeterConfigurationProvisioningState CANCELED = fromString("Canceled");

    /**
     * Creates a new instance of NetworkSecurityPerimeterConfigurationProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkSecurityPerimeterConfigurationProvisioningState() {
    }

    /**
     * Creates or finds a NetworkSecurityPerimeterConfigurationProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkSecurityPerimeterConfigurationProvisioningState.
     */
    @JsonCreator
    public static NetworkSecurityPerimeterConfigurationProvisioningState fromString(String name) {
        return fromString(name, NetworkSecurityPerimeterConfigurationProvisioningState.class);
    }

    /**
     * Gets known NetworkSecurityPerimeterConfigurationProvisioningState values.
     * 
     * @return known NetworkSecurityPerimeterConfigurationProvisioningState values.
     */
    public static Collection<NetworkSecurityPerimeterConfigurationProvisioningState> values() {
        return values(NetworkSecurityPerimeterConfigurationProvisioningState.class);
    }
}
