// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.storage.fluent.models.LocalUserInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * List of local users requested, and if paging is required, a URL to the next page of local users.
 */
@Fluent
public final class LocalUsers {
    /*
     * The list of local users associated with the storage account.
     */
    @JsonProperty(value = "value")
    private List<LocalUserInner> value;

    /*
     * Request URL that can be used to query next page of local users. Returned when total number of requested local
     * users exceeds the maximum page size.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Creates an instance of LocalUsers class.
     */
    public LocalUsers() {
    }

    /**
     * Get the value property: The list of local users associated with the storage account.
     * 
     * @return the value value.
     */
    public List<LocalUserInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of local users associated with the storage account.
     * 
     * @param value the value value to set.
     * @return the LocalUsers object itself.
     */
    public LocalUsers withValue(List<LocalUserInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of local users. Returned when total
     * number of requested local users exceeds the maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
