// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Lease state of the container.
 */
public final class LeaseState extends ExpandableStringEnum<LeaseState> {
    /**
     * Static value Available for LeaseState.
     */
    public static final LeaseState AVAILABLE = fromString("Available");

    /**
     * Static value Leased for LeaseState.
     */
    public static final LeaseState LEASED = fromString("Leased");

    /**
     * Static value Expired for LeaseState.
     */
    public static final LeaseState EXPIRED = fromString("Expired");

    /**
     * Static value Breaking for LeaseState.
     */
    public static final LeaseState BREAKING = fromString("Breaking");

    /**
     * Static value Broken for LeaseState.
     */
    public static final LeaseState BROKEN = fromString("Broken");

    /**
     * Creates a new instance of LeaseState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LeaseState() {
    }

    /**
     * Creates or finds a LeaseState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LeaseState.
     */
    @JsonCreator
    public static LeaseState fromString(String name) {
        return fromString(name, LeaseState.class);
    }

    /**
     * Gets known LeaseState values.
     * 
     * @return known LeaseState values.
     */
    public static Collection<LeaseState> values() {
        return values(LeaseState.class);
    }
}
