// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Execution trigger update for storage task assignment.
 */
@Fluent
public final class ExecutionTriggerUpdate {
    /*
     * The trigger type of the storage task assignment execution
     */
    @JsonProperty(value = "type")
    private TriggerType type;

    /*
     * The trigger parameters of the storage task assignment execution
     */
    @JsonProperty(value = "parameters")
    private TriggerParametersUpdate parameters;

    /**
     * Creates an instance of ExecutionTriggerUpdate class.
     */
    public ExecutionTriggerUpdate() {
    }

    /**
     * Get the type property: The trigger type of the storage task assignment execution.
     * 
     * @return the type value.
     */
    public TriggerType type() {
        return this.type;
    }

    /**
     * Set the type property: The trigger type of the storage task assignment execution.
     * 
     * @param type the type value to set.
     * @return the ExecutionTriggerUpdate object itself.
     */
    public ExecutionTriggerUpdate withType(TriggerType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the parameters property: The trigger parameters of the storage task assignment execution.
     * 
     * @return the parameters value.
     */
    public TriggerParametersUpdate parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The trigger parameters of the storage task assignment execution.
     * 
     * @param parameters the parameters value to set.
     * @return the ExecutionTriggerUpdate object itself.
     */
    public ExecutionTriggerUpdate withParameters(TriggerParametersUpdate parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (parameters() != null) {
            parameters().validate();
        }
    }
}
