// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Target helps provide filter parameters for the objects in the storage account and forms the execution context for the
 * storage task.
 */
@Fluent
public final class ExecutionTarget {
    /*
     * Required list of object prefixes to be included for task execution
     */
    @JsonProperty(value = "prefix")
    private List<String> prefix;

    /*
     * List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude
     * prefixes, the exclude prefix will be the determining factor
     */
    @JsonProperty(value = "excludePrefix")
    private List<String> excludePrefix;

    /**
     * Creates an instance of ExecutionTarget class.
     */
    public ExecutionTarget() {
    }

    /**
     * Get the prefix property: Required list of object prefixes to be included for task execution.
     * 
     * @return the prefix value.
     */
    public List<String> prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: Required list of object prefixes to be included for task execution.
     * 
     * @param prefix the prefix value to set.
     * @return the ExecutionTarget object itself.
     */
    public ExecutionTarget withPrefix(List<String> prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the excludePrefix property: List of object prefixes to be excluded from task execution. If there is a
     * conflict between include and exclude prefixes, the exclude prefix will be the determining factor.
     * 
     * @return the excludePrefix value.
     */
    public List<String> excludePrefix() {
        return this.excludePrefix;
    }

    /**
     * Set the excludePrefix property: List of object prefixes to be excluded from task execution. If there is a
     * conflict between include and exclude prefixes, the exclude prefix will be the determining factor.
     * 
     * @param excludePrefix the excludePrefix value to set.
     * @return the ExecutionTarget object itself.
     */
    public ExecutionTarget withExcludePrefix(List<String> excludePrefix) {
        this.excludePrefix = excludePrefix;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
