// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is
 * set to 'Microsoft.KeyVault'.
 */
@Fluent
public final class EncryptionScopeKeyVaultProperties {
    /*
     * The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced
     * by the identifier to enable customer-managed key support on this encryption scope.
     */
    @JsonProperty(value = "keyUri")
    private String keyUri;

    /*
     * The object identifier of the current versioned Key Vault Key in use.
     */
    @JsonProperty(value = "currentVersionedKeyIdentifier", access = JsonProperty.Access.WRITE_ONLY)
    private String currentVersionedKeyIdentifier;

    /*
     * Timestamp of last rotation of the Key Vault Key.
     */
    @JsonProperty(value = "lastKeyRotationTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastKeyRotationTimestamp;

    /**
     * Creates an instance of EncryptionScopeKeyVaultProperties class.
     */
    public EncryptionScopeKeyVaultProperties() {
    }

    /**
     * Get the keyUri property: The object identifier for a key vault key object. When applied, the encryption scope
     * will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
     * 
     * @return the keyUri value.
     */
    public String keyUri() {
        return this.keyUri;
    }

    /**
     * Set the keyUri property: The object identifier for a key vault key object. When applied, the encryption scope
     * will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
     * 
     * @param keyUri the keyUri value to set.
     * @return the EncryptionScopeKeyVaultProperties object itself.
     */
    public EncryptionScopeKeyVaultProperties withKeyUri(String keyUri) {
        this.keyUri = keyUri;
        return this;
    }

    /**
     * Get the currentVersionedKeyIdentifier property: The object identifier of the current versioned Key Vault Key in
     * use.
     * 
     * @return the currentVersionedKeyIdentifier value.
     */
    public String currentVersionedKeyIdentifier() {
        return this.currentVersionedKeyIdentifier;
    }

    /**
     * Get the lastKeyRotationTimestamp property: Timestamp of last rotation of the Key Vault Key.
     * 
     * @return the lastKeyRotationTimestamp value.
     */
    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
