// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single
 * subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone
 * identifier.
 */
public final class DnsEndpointType extends ExpandableStringEnum<DnsEndpointType> {
    /**
     * Static value Standard for DnsEndpointType.
     */
    public static final DnsEndpointType STANDARD = fromString("Standard");

    /**
     * Static value AzureDnsZone for DnsEndpointType.
     */
    public static final DnsEndpointType AZURE_DNS_ZONE = fromString("AzureDnsZone");

    /**
     * Creates a new instance of DnsEndpointType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DnsEndpointType() {
    }

    /**
     * Creates or finds a DnsEndpointType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DnsEndpointType.
     */
    @JsonCreator
    public static DnsEndpointType fromString(String name) {
        return fromString(name, DnsEndpointType.class);
    }

    /**
     * Gets known DnsEndpointType values.
     * 
     * @return known DnsEndpointType values.
     */
    public static Collection<DnsEndpointType> values() {
        return values(DnsEndpointType.class);
    }
}
