// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationPropertiesProfile;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
import com.azure.resourcemanager.storage.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.azure.resourcemanager.storage.models.ProvisioningIssue;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Properties of the Network Security Perimeter Configuration.
 */
@Immutable
public final class NetworkSecurityPerimeterConfigurationProperties {
    /*
     * Provisioning state of Network Security Perimeter configuration propagation
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private NetworkSecurityPerimeterConfigurationProvisioningState provisioningState;

    /*
     * List of Provisioning Issues if any
     */
    @JsonProperty(value = "provisioningIssues", access = JsonProperty.Access.WRITE_ONLY)
    private List<ProvisioningIssue> provisioningIssues;

    /*
     * NetworkSecurityPerimeter related information
     */
    @JsonProperty(value = "networkSecurityPerimeter", access = JsonProperty.Access.WRITE_ONLY)
    private NetworkSecurityPerimeter networkSecurityPerimeter;

    /*
     * Information about resource association
     */
    @JsonProperty(value = "resourceAssociation", access = JsonProperty.Access.WRITE_ONLY)
    private NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation;

    /*
     * Network Security Perimeter profile
     */
    @JsonProperty(value = "profile", access = JsonProperty.Access.WRITE_ONLY)
    private NetworkSecurityPerimeterConfigurationPropertiesProfile profile;

    /**
     * Creates an instance of NetworkSecurityPerimeterConfigurationProperties class.
     */
    public NetworkSecurityPerimeterConfigurationProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of Network Security Perimeter configuration propagation.
     * 
     * @return the provisioningState value.
     */
    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningIssues property: List of Provisioning Issues if any.
     * 
     * @return the provisioningIssues value.
     */
    public List<ProvisioningIssue> provisioningIssues() {
        return this.provisioningIssues;
    }

    /**
     * Get the networkSecurityPerimeter property: NetworkSecurityPerimeter related information.
     * 
     * @return the networkSecurityPerimeter value.
     */
    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    /**
     * Get the resourceAssociation property: Information about resource association.
     * 
     * @return the resourceAssociation value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    /**
     * Get the profile property: Network Security Perimeter profile.
     * 
     * @return the profile value.
     */
    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.profile;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (provisioningIssues() != null) {
            provisioningIssues().forEach(e -> e.validate());
        }
        if (networkSecurityPerimeter() != null) {
            networkSecurityPerimeter().validate();
        }
        if (resourceAssociation() != null) {
            resourceAssociation().validate();
        }
        if (profile() != null) {
            profile().validate();
        }
    }
}
