// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * This property defines the creation time based filtering condition. Blob Inventory schema parameter 'Creation-Time' is
 * mandatory with this filter.
 */
@Fluent
public final class BlobInventoryCreationTime {
    /*
     * When set the policy filters the objects that are created in the last N days. Where N is an integer value between
     * 1 to 36500.
     */
    @JsonProperty(value = "lastNDays")
    private Integer lastNDays;

    /** Creates an instance of BlobInventoryCreationTime class. */
    public BlobInventoryCreationTime() {
    }

    /**
     * Get the lastNDays property: When set the policy filters the objects that are created in the last N days. Where N
     * is an integer value between 1 to 36500.
     *
     * @return the lastNDays value.
     */
    public Integer lastNDays() {
        return this.lastNDays;
    }

    /**
     * Set the lastNDays property: When set the policy filters the objects that are created in the last N days. Where N
     * is an integer value between 1 to 36500.
     *
     * @param lastNDays the lastNDays value to set.
     * @return the BlobInventoryCreationTime object itself.
     */
    public BlobInventoryCreationTime withLastNDays(Integer lastNDays) {
        this.lastNDays = lastNDays;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
