/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ObjectReplicationPolicyRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ObjectReplicationPolicyRule.class);
    @JsonProperty(value="ruleId")
    private String ruleId;
    @JsonProperty(value="sourceContainer", required=true)
    private String sourceContainer;
    @JsonProperty(value="destinationContainer", required=true)
    private String destinationContainer;
    @JsonProperty(value="filters")
    private ObjectReplicationPolicyFilter filters;

    public String ruleId() {
        return this.ruleId;
    }

    public ObjectReplicationPolicyRule withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String sourceContainer() {
        return this.sourceContainer;
    }

    public ObjectReplicationPolicyRule withSourceContainer(String sourceContainer) {
        this.sourceContainer = sourceContainer;
        return this;
    }

    public String destinationContainer() {
        return this.destinationContainer;
    }

    public ObjectReplicationPolicyRule withDestinationContainer(String destinationContainer) {
        this.destinationContainer = destinationContainer;
        return this;
    }

    public ObjectReplicationPolicyFilter filters() {
        return this.filters;
    }

    public ObjectReplicationPolicyRule withFilters(ObjectReplicationPolicyFilter filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.sourceContainer() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceContainer in model ObjectReplicationPolicyRule"));
        }
        if (this.destinationContainer() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property destinationContainer in model ObjectReplicationPolicyRule"));
        }
        if (this.filters() != null) {
            this.filters().validate();
        }
    }
}

