/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ImmutabilityPolicyProperties;
import com.azure.resourcemanager.storage.models.ImmutableStorageWithVersioning;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.LegalHoldProperties;
import com.azure.resourcemanager.storage.models.PublicAccess;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ContainerProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerProperties.class);
    @JsonProperty(value="version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="deleted", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean deleted;
    @JsonProperty(value="deletedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime deletedTime;
    @JsonProperty(value="remainingRetentionDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer remainingRetentionDays;
    @JsonProperty(value="defaultEncryptionScope")
    private String defaultEncryptionScope;
    @JsonProperty(value="denyEncryptionScopeOverride")
    private Boolean denyEncryptionScopeOverride;
    @JsonProperty(value="publicAccess")
    private PublicAccess publicAccess;
    @JsonProperty(value="lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="leaseStatus", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseStatus leaseStatus;
    @JsonProperty(value="leaseState", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseState leaseState;
    @JsonProperty(value="leaseDuration", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseDuration leaseDuration;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> metadata;
    @JsonProperty(value="immutabilityPolicy", access=JsonProperty.Access.WRITE_ONLY)
    private ImmutabilityPolicyProperties immutabilityPolicy;
    @JsonProperty(value="legalHold", access=JsonProperty.Access.WRITE_ONLY)
    private LegalHoldProperties legalHold;
    @JsonProperty(value="hasLegalHold", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasLegalHold;
    @JsonProperty(value="hasImmutabilityPolicy", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasImmutabilityPolicy;
    @JsonProperty(value="immutableStorageWithVersioning")
    private ImmutableStorageWithVersioning immutableStorageWithVersioning;
    @JsonProperty(value="enableNfsV3RootSquash")
    private Boolean enableNfsV3RootSquash;
    @JsonProperty(value="enableNfsV3AllSquash")
    private Boolean enableNfsV3AllSquash;

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public String defaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    public ContainerProperties withDefaultEncryptionScope(String defaultEncryptionScope) {
        this.defaultEncryptionScope = defaultEncryptionScope;
        return this;
    }

    public Boolean denyEncryptionScopeOverride() {
        return this.denyEncryptionScopeOverride;
    }

    public ContainerProperties withDenyEncryptionScopeOverride(Boolean denyEncryptionScopeOverride) {
        this.denyEncryptionScopeOverride = denyEncryptionScopeOverride;
        return this;
    }

    public PublicAccess publicAccess() {
        return this.publicAccess;
    }

    public ContainerProperties withPublicAccess(PublicAccess publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ContainerProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ImmutabilityPolicyProperties immutabilityPolicy() {
        return this.immutabilityPolicy;
    }

    public LegalHoldProperties legalHold() {
        return this.legalHold;
    }

    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public Boolean hasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public ImmutableStorageWithVersioning immutableStorageWithVersioning() {
        return this.immutableStorageWithVersioning;
    }

    public ContainerProperties withImmutableStorageWithVersioning(ImmutableStorageWithVersioning immutableStorageWithVersioning) {
        this.immutableStorageWithVersioning = immutableStorageWithVersioning;
        return this;
    }

    public Boolean enableNfsV3RootSquash() {
        return this.enableNfsV3RootSquash;
    }

    public ContainerProperties withEnableNfsV3RootSquash(Boolean enableNfsV3RootSquash) {
        this.enableNfsV3RootSquash = enableNfsV3RootSquash;
        return this;
    }

    public Boolean enableNfsV3AllSquash() {
        return this.enableNfsV3AllSquash;
    }

    public ContainerProperties withEnableNfsV3AllSquash(Boolean enableNfsV3AllSquash) {
        this.enableNfsV3AllSquash = enableNfsV3AllSquash;
        return this;
    }

    public void validate() {
        if (this.immutabilityPolicy() != null) {
            this.immutabilityPolicy().validate();
        }
        if (this.legalHold() != null) {
            this.legalHold().validate();
        }
        if (this.immutableStorageWithVersioning() != null) {
            this.immutableStorageWithVersioning().validate();
        }
    }
}

