// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.models.LocalUserInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List storage account local users. */
@Fluent
public final class LocalUsers {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LocalUsers.class);

    /*
     * The local users associated with the storage account.
     */
    @JsonProperty(value = "value")
    private List<LocalUserInner> value;

    /**
     * Get the value property: The local users associated with the storage account.
     *
     * @return the value value.
     */
    public List<LocalUserInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The local users associated with the storage account.
     *
     * @param value the value value to set.
     * @return the LocalUsers object itself.
     */
    public LocalUsers withValue(List<LocalUserInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
