// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for InventoryRuleType. */
public final class InventoryRuleType extends ExpandableStringEnum<InventoryRuleType> {
    /** Static value Inventory for InventoryRuleType. */
    public static final InventoryRuleType INVENTORY = fromString("Inventory");

    /**
     * Creates or finds a InventoryRuleType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding InventoryRuleType.
     */
    @JsonCreator
    public static InventoryRuleType fromString(String name) {
        return fromString(name, InventoryRuleType.class);
    }

    /** @return known InventoryRuleType values. */
    public static Collection<InventoryRuleType> values() {
        return values(InventoryRuleType.class);
    }
}
