// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.fluent.FileSharesClient;
import com.azure.resourcemanager.storage.fluent.models.FileShareInner;
import com.azure.resourcemanager.storage.fluent.models.FileShareItemInner;
import com.azure.resourcemanager.storage.fluent.models.LeaseShareResponseInner;
import com.azure.resourcemanager.storage.models.DeletedShare;
import com.azure.resourcemanager.storage.models.FileShareItems;
import com.azure.resourcemanager.storage.models.FileSharesLeaseResponse;
import com.azure.resourcemanager.storage.models.LeaseShareRequest;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in FileSharesClient. */
public final class FileSharesClientImpl implements FileSharesClient {
    private final ClientLogger logger = new ClientLogger(FileSharesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final FileSharesService service;

    /** The service client containing this operation class. */
    private final StorageManagementClientImpl client;

    /**
     * Initializes an instance of FileSharesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    FileSharesClientImpl(StorageManagementClientImpl client) {
        this.service =
            RestProxy.create(FileSharesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for StorageManagementClientFileShares to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "StorageManagementCli")
    private interface FileSharesService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FileShareItems>> list(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("$maxpagesize") String maxpagesize,
            @QueryParam("$filter") String filter,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FileShareInner>> create(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("shareName") String shareName,
            @QueryParam("$expand") String expand,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") FileShareInner fileShare,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FileShareInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("shareName") String shareName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") FileShareInner fileShare,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FileShareInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("shareName") String shareName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("$expand") String expand,
            @HeaderParam("x-ms-snapshot") String xMsSnapshot,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares/{shareName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("shareName") String shareName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("x-ms-snapshot") String xMsSnapshot,
            @QueryParam("$include") String include,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares/{shareName}/restore")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> restore(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("shareName") String shareName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") DeletedShare deletedShare,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage"
                + "/storageAccounts/{accountName}/fileServices/default/shares/{shareName}/lease")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<FileSharesLeaseResponse> lease(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("shareName") String shareName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("x-ms-snapshot") String xMsSnapshot,
            @BodyParam("application/json") LeaseShareRequest parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FileShareItems>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param maxpagesize Optional. Specified maximum number of shares that can be included in the list.
     * @param filter Optional. When specified, only share names starting with the filter will be listed.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: deleted,
     *     snapshots. Should be passed as a string with delimiter ','.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listSinglePageAsync(
        String resourceGroupName, String accountName, String maxpagesize, String filter, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            maxpagesize,
                            filter,
                            expand,
                            accept,
                            context))
            .<PagedResponse<FileShareItemInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param maxpagesize Optional. Specified maximum number of shares that can be included in the list.
     * @param filter Optional. When specified, only share names starting with the filter will be listed.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: deleted,
     *     snapshots. Should be passed as a string with delimiter ','.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listSinglePageAsync(
        String resourceGroupName,
        String accountName,
        String maxpagesize,
        String filter,
        String expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                maxpagesize,
                filter,
                expand,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param maxpagesize Optional. Specified maximum number of shares that can be included in the list.
     * @param filter Optional. When specified, only share names starting with the filter will be listed.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: deleted,
     *     snapshots. Should be passed as a string with delimiter ','.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FileShareItemInner> listAsync(
        String resourceGroupName, String accountName, String maxpagesize, String filter, String expand) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<FileShareItemInner> listAsync(String resourceGroupName, String accountName) {
        final String maxpagesize = null;
        final String filter = null;
        final String expand = null;
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param maxpagesize Optional. Specified maximum number of shares that can be included in the list.
     * @param filter Optional. When specified, only share names starting with the filter will be listed.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: deleted,
     *     snapshots. Should be passed as a string with delimiter ','.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FileShareItemInner> listAsync(
        String resourceGroupName,
        String accountName,
        String maxpagesize,
        String filter,
        String expand,
        Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, accountName, maxpagesize, filter, expand, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FileShareItemInner> list(String resourceGroupName, String accountName) {
        final String maxpagesize = null;
        final String filter = null;
        final String expand = null;
        return new PagedIterable<>(listAsync(resourceGroupName, accountName, maxpagesize, filter, expand));
    }

    /**
     * Lists all shares.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param maxpagesize Optional. Specified maximum number of shares that can be included in the list.
     * @param filter Optional. When specified, only share names starting with the filter will be listed.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: deleted,
     *     snapshots. Should be passed as a string with delimiter ','.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FileShareItemInner> list(
        String resourceGroupName,
        String accountName,
        String maxpagesize,
        String filter,
        String expand,
        Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, accountName, maxpagesize, filter, expand, context));
    }

    /**
     * Creates a new share under the specified account as described by request body. The share resource includes
     * metadata and properties for that share. It does not include a list of the files contained by the share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties of the file share to create.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: snapshots.
     *     Should be passed as a string with delimiter ','.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FileShareInner>> createWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        } else {
            fileShare.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            shareName,
                            expand,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            fileShare,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new share under the specified account as described by request body. The share resource includes
     * metadata and properties for that share. It does not include a list of the files contained by the share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties of the file share to create.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: snapshots.
     *     Should be passed as a string with delimiter ','.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FileShareInner>> createWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String shareName,
        FileShareInner fileShare,
        String expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        } else {
            fileShare.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                shareName,
                expand,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                fileShare,
                accept,
                context);
    }

    /**
     * Creates a new share under the specified account as described by request body. The share resource includes
     * metadata and properties for that share. It does not include a list of the files contained by the share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties of the file share to create.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: snapshots.
     *     Should be passed as a string with delimiter ','.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FileShareInner> createAsync(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, String expand) {
        return createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand)
            .flatMap(
                (Response<FileShareInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates a new share under the specified account as described by request body. The share resource includes
     * metadata and properties for that share. It does not include a list of the files contained by the share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties of the file share to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FileShareInner> createAsync(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        final String expand = null;
        return createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand)
            .flatMap(
                (Response<FileShareInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates a new share under the specified account as described by request body. The share resource includes
     * metadata and properties for that share. It does not include a list of the files contained by the share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties of the file share to create.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FileShareInner create(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        final String expand = null;
        return createAsync(resourceGroupName, accountName, shareName, fileShare, expand).block();
    }

    /**
     * Creates a new share under the specified account as described by request body. The share resource includes
     * metadata and properties for that share. It does not include a list of the files contained by the share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties of the file share to create.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: snapshots.
     *     Should be passed as a string with delimiter ','.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FileShareInner> createWithResponse(
        String resourceGroupName,
        String accountName,
        String shareName,
        FileShareInner fileShare,
        String expand,
        Context context) {
        return createWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, expand, context).block();
    }

    /**
     * Updates share properties as specified in request body. Properties not mentioned in the request will not be
     * changed. Update fails if the specified share does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties to update for the file share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FileShareInner>> updateWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        } else {
            fileShare.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            shareName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            fileShare,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates share properties as specified in request body. Properties not mentioned in the request will not be
     * changed. Update fails if the specified share does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties to update for the file share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FileShareInner>> updateWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (fileShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter fileShare is required and cannot be null."));
        } else {
            fileShare.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                shareName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                fileShare,
                accept,
                context);
    }

    /**
     * Updates share properties as specified in request body. Properties not mentioned in the request will not be
     * changed. Update fails if the specified share does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties to update for the file share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FileShareInner> updateAsync(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return updateWithResponseAsync(resourceGroupName, accountName, shareName, fileShare)
            .flatMap(
                (Response<FileShareInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Updates share properties as specified in request body. Properties not mentioned in the request will not be
     * changed. Update fails if the specified share does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties to update for the file share.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FileShareInner update(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare) {
        return updateAsync(resourceGroupName, accountName, shareName, fileShare).block();
    }

    /**
     * Updates share properties as specified in request body. Properties not mentioned in the request will not be
     * changed. Update fails if the specified share does not already exist.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param fileShare Properties to update for the file share.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of the file share, including Id, resource name, resource type, Etag along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FileShareInner> updateWithResponse(
        String resourceGroupName, String accountName, String shareName, FileShareInner fileShare, Context context) {
        return updateWithResponseAsync(resourceGroupName, accountName, shareName, fileShare, context).block();
    }

    /**
     * Gets properties of a specified share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: stats. Should
     *     be passed as a string with delimiter ','.
     * @param xMsSnapshot Optional, used to retrieve properties of a snapshot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a specified share along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<FileShareInner>> getWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, String expand, String xMsSnapshot) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            shareName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            expand,
                            xMsSnapshot,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets properties of a specified share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: stats. Should
     *     be passed as a string with delimiter ','.
     * @param xMsSnapshot Optional, used to retrieve properties of a snapshot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a specified share along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FileShareInner>> getWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String shareName,
        String expand,
        String xMsSnapshot,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                shareName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                expand,
                xMsSnapshot,
                accept,
                context);
    }

    /**
     * Gets properties of a specified share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: stats. Should
     *     be passed as a string with delimiter ','.
     * @param xMsSnapshot Optional, used to retrieve properties of a snapshot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a specified share on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FileShareInner> getAsync(
        String resourceGroupName, String accountName, String shareName, String expand, String xMsSnapshot) {
        return getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot)
            .flatMap(
                (Response<FileShareInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets properties of a specified share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a specified share on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FileShareInner> getAsync(String resourceGroupName, String accountName, String shareName) {
        final String expand = null;
        final String xMsSnapshot = null;
        return getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot)
            .flatMap(
                (Response<FileShareInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets properties of a specified share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a specified share.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FileShareInner get(String resourceGroupName, String accountName, String shareName) {
        final String expand = null;
        final String xMsSnapshot = null;
        return getAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot).block();
    }

    /**
     * Gets properties of a specified share.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: stats. Should
     *     be passed as a string with delimiter ','.
     * @param xMsSnapshot Optional, used to retrieve properties of a snapshot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties of a specified share along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FileShareInner> getWithResponse(
        String resourceGroupName,
        String accountName,
        String shareName,
        String expand,
        String xMsSnapshot,
        Context context) {
        return getWithResponseAsync(resourceGroupName, accountName, shareName, expand, xMsSnapshot, context).block();
    }

    /**
     * Deletes specified share under its account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional, used to delete a snapshot.
     * @param include Optional. Valid values are: snapshots, leased-snapshots, none. The default value is snapshots. For
     *     'snapshots', the file share is deleted including all of its file share snapshots. If the file share contains
     *     leased-snapshots, the deletion fails. For 'leased-snapshots', the file share is deleted included all of its
     *     file share snapshots (leased/unleased). For 'none', the file share is deleted if it has no share snapshots.
     *     If the file share contains any snapshots (leased or unleased), the deletion fails.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, String xMsSnapshot, String include) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            shareName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            xMsSnapshot,
                            include,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes specified share under its account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional, used to delete a snapshot.
     * @param include Optional. Valid values are: snapshots, leased-snapshots, none. The default value is snapshots. For
     *     'snapshots', the file share is deleted including all of its file share snapshots. If the file share contains
     *     leased-snapshots, the deletion fails. For 'leased-snapshots', the file share is deleted included all of its
     *     file share snapshots (leased/unleased). For 'none', the file share is deleted if it has no share snapshots.
     *     If the file share contains any snapshots (leased or unleased), the deletion fails.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String shareName,
        String xMsSnapshot,
        String include,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                shareName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                xMsSnapshot,
                include,
                accept,
                context);
    }

    /**
     * Deletes specified share under its account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional, used to delete a snapshot.
     * @param include Optional. Valid values are: snapshots, leased-snapshots, none. The default value is snapshots. For
     *     'snapshots', the file share is deleted including all of its file share snapshots. If the file share contains
     *     leased-snapshots, the deletion fails. For 'leased-snapshots', the file share is deleted included all of its
     *     file share snapshots (leased/unleased). For 'none', the file share is deleted if it has no share snapshots.
     *     If the file share contains any snapshots (leased or unleased), the deletion fails.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName, String accountName, String shareName, String xMsSnapshot, String include) {
        return deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, include)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes specified share under its account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String accountName, String shareName) {
        final String xMsSnapshot = null;
        final String include = null;
        return deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, include)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Deletes specified share under its account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String accountName, String shareName) {
        final String xMsSnapshot = null;
        final String include = null;
        deleteAsync(resourceGroupName, accountName, shareName, xMsSnapshot, include).block();
    }

    /**
     * Deletes specified share under its account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional, used to delete a snapshot.
     * @param include Optional. Valid values are: snapshots, leased-snapshots, none. The default value is snapshots. For
     *     'snapshots', the file share is deleted including all of its file share snapshots. If the file share contains
     *     leased-snapshots, the deletion fails. For 'leased-snapshots', the file share is deleted included all of its
     *     file share snapshots (leased/unleased). For 'none', the file share is deleted if it has no share snapshots.
     *     If the file share contains any snapshots (leased or unleased), the deletion fails.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
        String resourceGroupName,
        String accountName,
        String shareName,
        String xMsSnapshot,
        String include,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, include, context)
            .block();
    }

    /**
     * Restore a file share within a valid retention days if share soft delete is enabled.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param deletedShare The deleted share to be restored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> restoreWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deletedShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedShare is required and cannot be null."));
        } else {
            deletedShare.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .restore(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            shareName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            deletedShare,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Restore a file share within a valid retention days if share soft delete is enabled.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param deletedShare The deleted share to be restored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> restoreWithResponseAsync(
        String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deletedShare == null) {
            return Mono.error(new IllegalArgumentException("Parameter deletedShare is required and cannot be null."));
        } else {
            deletedShare.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .restore(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                shareName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                deletedShare,
                accept,
                context);
    }

    /**
     * Restore a file share within a valid retention days if share soft delete is enabled.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param deletedShare The deleted share to be restored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restoreAsync(
        String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare) {
        return restoreWithResponseAsync(resourceGroupName, accountName, shareName, deletedShare)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Restore a file share within a valid retention days if share soft delete is enabled.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param deletedShare The deleted share to be restored.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restore(String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare) {
        restoreAsync(resourceGroupName, accountName, shareName, deletedShare).block();
    }

    /**
     * Restore a file share within a valid retention days if share soft delete is enabled.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param deletedShare The deleted share to be restored.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> restoreWithResponse(
        String resourceGroupName, String accountName, String shareName, DeletedShare deletedShare, Context context) {
        return restoreWithResponseAsync(resourceGroupName, accountName, shareName, deletedShare, context).block();
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional. Specify the snapshot time to lease a snapshot.
     * @param parameters Lease Share request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lease Share response schema on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<FileSharesLeaseResponse> leaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String shareName,
        String xMsSnapshot,
        LeaseShareRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .lease(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            accountName,
                            shareName,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            xMsSnapshot,
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional. Specify the snapshot time to lease a snapshot.
     * @param parameters Lease Share request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lease Share response schema on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FileSharesLeaseResponse> leaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String shareName,
        String xMsSnapshot,
        LeaseShareRequest parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (shareName == null) {
            return Mono.error(new IllegalArgumentException("Parameter shareName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .lease(
                this.client.getEndpoint(),
                resourceGroupName,
                accountName,
                shareName,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                xMsSnapshot,
                parameters,
                accept,
                context);
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional. Specify the snapshot time to lease a snapshot.
     * @param parameters Lease Share request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lease Share response schema on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LeaseShareResponseInner> leaseAsync(
        String resourceGroupName,
        String accountName,
        String shareName,
        String xMsSnapshot,
        LeaseShareRequest parameters) {
        return leaseWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, parameters)
            .flatMap(
                (FileSharesLeaseResponse res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lease Share response schema on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LeaseShareResponseInner> leaseAsync(String resourceGroupName, String accountName, String shareName) {
        final String xMsSnapshot = null;
        final LeaseShareRequest parameters = null;
        return leaseWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, parameters)
            .flatMap(
                (FileSharesLeaseResponse res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lease Share response schema.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LeaseShareResponseInner lease(String resourceGroupName, String accountName, String shareName) {
        final String xMsSnapshot = null;
        final LeaseShareRequest parameters = null;
        return leaseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, parameters).block();
    }

    /**
     * The Lease Share operation establishes and manages a lock on a share for delete operations. The lock duration can
     * be 15 to 60 seconds, or can be infinite.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case
     *     insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names
     *     must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param shareName The name of the file share within the specified storage account. File share names must be
     *     between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-)
     *     character must be immediately preceded and followed by a letter or number.
     * @param xMsSnapshot Optional. Specify the snapshot time to lease a snapshot.
     * @param parameters Lease Share request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return lease Share response schema.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FileSharesLeaseResponse leaseWithResponse(
        String resourceGroupName,
        String accountName,
        String shareName,
        String xMsSnapshot,
        LeaseShareRequest parameters,
        Context context) {
        return leaseWithResponseAsync(resourceGroupName, accountName, shareName, xMsSnapshot, parameters, context)
            .block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<FileShareItemInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response schema along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FileShareItemInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
