// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The secrets of Storage Account Local User. */
@Immutable
public final class LocalUserRegeneratePasswordResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LocalUserRegeneratePasswordResultInner.class);

    /*
     * Auto generated password by the server for SSH authentication if
     * hasSshPassword is set to true on the creation of local user.
     */
    @JsonProperty(value = "sshPassword", access = JsonProperty.Access.WRITE_ONLY)
    private String sshPassword;

    /**
     * Get the sshPassword property: Auto generated password by the server for SSH authentication if hasSshPassword is
     * set to true on the creation of local user.
     *
     * @return the sshPassword value.
     */
    public String sshPassword() {
        return this.sshPassword;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
