/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SyncGroupSchemaTable;
import java.io.IOException;
import java.util.List;

public final class SyncGroupSchema
implements JsonSerializable<SyncGroupSchema> {
    private List<SyncGroupSchemaTable> tables;
    private String masterSyncMemberName;

    public List<SyncGroupSchemaTable> tables() {
        return this.tables;
    }

    public SyncGroupSchema withTables(List<SyncGroupSchemaTable> tables) {
        this.tables = tables;
        return this;
    }

    public String masterSyncMemberName() {
        return this.masterSyncMemberName;
    }

    public SyncGroupSchema withMasterSyncMemberName(String masterSyncMemberName) {
        this.masterSyncMemberName = masterSyncMemberName;
        return this;
    }

    public void validate() {
        if (this.tables() != null) {
            this.tables().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("masterSyncMemberName", this.masterSyncMemberName);
        return jsonWriter.writeEndObject();
    }

    public static SyncGroupSchema fromJson(JsonReader jsonReader) throws IOException {
        return (SyncGroupSchema)jsonReader.readObject(reader -> {
            SyncGroupSchema deserializedSyncGroupSchema = new SyncGroupSchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tables".equals(fieldName)) {
                    List tables;
                    deserializedSyncGroupSchema.tables = tables = reader.readArray(reader1 -> SyncGroupSchemaTable.fromJson(reader1));
                    continue;
                }
                if ("masterSyncMemberName".equals(fieldName)) {
                    deserializedSyncGroupSchema.masterSyncMemberName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncGroupSchema;
        });
    }
}

