/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import java.io.IOException;

public final class ServerVulnerabilityAssessmentProperties
implements JsonSerializable<ServerVulnerabilityAssessmentProperties> {
    private String storageContainerPath;
    private String storageContainerSasKey;
    private String storageAccountAccessKey;
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;
    private static final ClientLogger LOGGER = new ClientLogger(ServerVulnerabilityAssessmentProperties.class);

    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    public ServerVulnerabilityAssessmentProperties withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    public ServerVulnerabilityAssessmentProperties withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public ServerVulnerabilityAssessmentProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    public ServerVulnerabilityAssessmentProperties withRecurringScans(VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

    public void validate() {
        if (this.storageContainerPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageContainerPath in model ServerVulnerabilityAssessmentProperties"));
        }
        if (this.recurringScans() != null) {
            this.recurringScans().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageContainerPath", this.storageContainerPath);
        jsonWriter.writeStringField("storageContainerSasKey", this.storageContainerSasKey);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeJsonField("recurringScans", (JsonSerializable)this.recurringScans);
        return jsonWriter.writeEndObject();
    }

    public static ServerVulnerabilityAssessmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerVulnerabilityAssessmentProperties)jsonReader.readObject(reader -> {
            ServerVulnerabilityAssessmentProperties deserializedServerVulnerabilityAssessmentProperties = new ServerVulnerabilityAssessmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageContainerPath".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.storageContainerPath = reader.getString();
                    continue;
                }
                if ("storageContainerSasKey".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.storageContainerSasKey = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("recurringScans".equals(fieldName)) {
                    deserializedServerVulnerabilityAssessmentProperties.recurringScans = VulnerabilityAssessmentRecurringScansProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerVulnerabilityAssessmentProperties;
        });
    }
}

