/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceKeyProperties;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagedInstanceKeyInner
extends ProxyResource {
    private String kind;
    private ManagedInstanceKeyProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String kind() {
        return this.kind;
    }

    private ManagedInstanceKeyProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ServerKeyType serverKeyType() {
        return this.innerProperties() == null ? null : this.innerProperties().serverKeyType();
    }

    public ManagedInstanceKeyInner withServerKeyType(ServerKeyType serverKeyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceKeyProperties();
        }
        this.innerProperties().withServerKeyType(serverKeyType);
        return this;
    }

    public String uri() {
        return this.innerProperties() == null ? null : this.innerProperties().uri();
    }

    public ManagedInstanceKeyInner withUri(String uri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedInstanceKeyProperties();
        }
        this.innerProperties().withUri(uri);
        return this;
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public Boolean autoRotationEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().autoRotationEnabled();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceKeyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceKeyInner)((Object)jsonReader.readObject(reader -> {
            ManagedInstanceKeyInner deserializedManagedInstanceKeyInner = new ManagedInstanceKeyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedInstanceKeyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceKeyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedInstanceKeyInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedManagedInstanceKeyInner.kind = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedInstanceKeyInner.innerProperties = ManagedInstanceKeyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceKeyInner;
        }));
    }
}

