/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ManagedDatabaseRestoreDetailsProperties
implements JsonSerializable<ManagedDatabaseRestoreDetailsProperties> {
    private String status;
    private String currentRestoringFileName;
    private String lastRestoredFileName;
    private OffsetDateTime lastRestoredFileTime;
    private Double percentCompleted;
    private List<String> unrestorableFiles;
    private Long numberOfFilesDetected;
    private String lastUploadedFileName;
    private OffsetDateTime lastUploadedFileTime;
    private String blockReason;

    public String status() {
        return this.status;
    }

    public String currentRestoringFileName() {
        return this.currentRestoringFileName;
    }

    public String lastRestoredFileName() {
        return this.lastRestoredFileName;
    }

    public OffsetDateTime lastRestoredFileTime() {
        return this.lastRestoredFileTime;
    }

    public Double percentCompleted() {
        return this.percentCompleted;
    }

    public List<String> unrestorableFiles() {
        return this.unrestorableFiles;
    }

    public Long numberOfFilesDetected() {
        return this.numberOfFilesDetected;
    }

    public String lastUploadedFileName() {
        return this.lastUploadedFileName;
    }

    public OffsetDateTime lastUploadedFileTime() {
        return this.lastUploadedFileTime;
    }

    public String blockReason() {
        return this.blockReason;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ManagedDatabaseRestoreDetailsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDatabaseRestoreDetailsProperties)jsonReader.readObject(reader -> {
            ManagedDatabaseRestoreDetailsProperties deserializedManagedDatabaseRestoreDetailsProperties = new ManagedDatabaseRestoreDetailsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.status = reader.getString();
                    continue;
                }
                if ("currentRestoringFileName".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.currentRestoringFileName = reader.getString();
                    continue;
                }
                if ("lastRestoredFileName".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastRestoredFileName = reader.getString();
                    continue;
                }
                if ("lastRestoredFileTime".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastRestoredFileTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.percentCompleted = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("unrestorableFiles".equals(fieldName)) {
                    List unrestorableFiles;
                    deserializedManagedDatabaseRestoreDetailsProperties.unrestorableFiles = unrestorableFiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("numberOfFilesDetected".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesDetected = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("lastUploadedFileName".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastUploadedFileName = reader.getString();
                    continue;
                }
                if ("lastUploadedFileTime".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastUploadedFileTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("blockReason".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.blockReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDatabaseRestoreDetailsProperties;
        });
    }
}

