/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.DatabaseProperties;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.DatabaseIdentity;
import com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.SecondaryType;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class DatabaseInner
extends Resource {
    private Sku sku;
    private String kind;
    private String managedBy;
    private DatabaseIdentity identity;
    private DatabaseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public DatabaseInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public String managedBy() {
        return this.managedBy;
    }

    public DatabaseIdentity identity() {
        return this.identity;
    }

    public DatabaseInner withIdentity(DatabaseIdentity identity) {
        this.identity = identity;
        return this;
    }

    private DatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DatabaseInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DatabaseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public DatabaseInner withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public DatabaseInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public DatabaseInner withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public SampleName sampleName() {
        return this.innerProperties() == null ? null : this.innerProperties().sampleName();
    }

    public DatabaseInner withSampleName(SampleName sampleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSampleName(sampleName);
        return this;
    }

    public String elasticPoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolId();
    }

    public DatabaseInner withElasticPoolId(String elasticPoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withElasticPoolId(elasticPoolId);
        return this;
    }

    public String sourceDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseId();
    }

    public DatabaseInner withSourceDatabaseId(String sourceDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    public DatabaseStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public UUID databaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseId();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public String currentServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().currentServiceObjectiveName();
    }

    public String requestedServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedServiceObjectiveName();
    }

    public String defaultSecondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecondaryLocation();
    }

    public String failoverGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverGroupId();
    }

    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    public DatabaseInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseDeletionDate();
    }

    public DatabaseInner withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseDeletionDate(sourceDatabaseDeletionDate);
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoveryServicesRecoveryPointId();
    }

    public DatabaseInner withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRecoveryServicesRecoveryPointId(recoveryServicesRecoveryPointId);
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().longTermRetentionBackupResourceId();
    }

    public DatabaseInner withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withLongTermRetentionBackupResourceId(longTermRetentionBackupResourceId);
        return this;
    }

    public String recoverableDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverableDatabaseId();
    }

    public DatabaseInner withRecoverableDatabaseId(String recoverableDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRecoverableDatabaseId(recoverableDatabaseId);
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableDroppedDatabaseId();
    }

    public DatabaseInner withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRestorableDroppedDatabaseId(restorableDroppedDatabaseId);
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.innerProperties() == null ? null : this.innerProperties().catalogCollation();
    }

    public DatabaseInner withCatalogCollation(CatalogCollationType catalogCollation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCatalogCollation(catalogCollation);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public DatabaseInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public DatabaseInner withLicenseType(DatabaseLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxLogSizeBytes();
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    public DatabaseReadScale readScale() {
        return this.innerProperties() == null ? null : this.innerProperties().readScale();
    }

    public DatabaseInner withReadScale(DatabaseReadScale readScale) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withReadScale(readScale);
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailabilityReplicaCount();
    }

    public DatabaseInner withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withHighAvailabilityReplicaCount(highAvailabilityReplicaCount);
        return this;
    }

    public SecondaryType secondaryType() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryType();
    }

    public DatabaseInner withSecondaryType(SecondaryType secondaryType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSecondaryType(secondaryType);
        return this;
    }

    public Sku currentSku() {
        return this.innerProperties() == null ? null : this.innerProperties().currentSku();
    }

    public Integer autoPauseDelay() {
        return this.innerProperties() == null ? null : this.innerProperties().autoPauseDelay();
    }

    public DatabaseInner withAutoPauseDelay(Integer autoPauseDelay) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withAutoPauseDelay(autoPauseDelay);
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().currentBackupStorageRedundancy();
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedBackupStorageRedundancy();
    }

    public DatabaseInner withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRequestedBackupStorageRedundancy(requestedBackupStorageRedundancy);
        return this;
    }

    public Double minCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().minCapacity();
    }

    public DatabaseInner withMinCapacity(Double minCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMinCapacity(minCapacity);
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().pausedDate();
    }

    public OffsetDateTime resumedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().resumedDate();
    }

    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    public DatabaseInner withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    public Boolean isLedgerOn() {
        return this.innerProperties() == null ? null : this.innerProperties().isLedgerOn();
    }

    public DatabaseInner withIsLedgerOn(Boolean isLedgerOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withIsLedgerOn(isLedgerOn);
        return this;
    }

    public Boolean isInfraEncryptionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isInfraEncryptionEnabled();
    }

    public UUID federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public DatabaseInner withFederatedClientId(UUID federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public String sourceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceResourceId();
    }

    public DatabaseInner withSourceResourceId(String sourceResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceResourceId(sourceResourceId);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseInner)((Object)jsonReader.readObject(reader -> {
            DatabaseInner deserializedDatabaseInner = new DatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabaseInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDatabaseInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDatabaseInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedDatabaseInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseInner.kind = reader.getString();
                    continue;
                }
                if ("managedBy".equals(fieldName)) {
                    deserializedDatabaseInner.managedBy = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDatabaseInner.identity = DatabaseIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseInner.innerProperties = DatabaseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseInner;
        }));
    }
}

