// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The read scale capability.
 */
@Fluent
public final class ReadScaleCapability implements JsonSerializable<ReadScaleCapability> {
    /*
     * The maximum number of read scale replicas.
     */
    private Integer maxNumberOfReplicas;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ReadScaleCapability class.
     */
    public ReadScaleCapability() {
    }

    /**
     * Get the maxNumberOfReplicas property: The maximum number of read scale replicas.
     * 
     * @return the maxNumberOfReplicas value.
     */
    public Integer maxNumberOfReplicas() {
        return this.maxNumberOfReplicas;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ReadScaleCapability object itself.
     */
    public ReadScaleCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReadScaleCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReadScaleCapability if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReadScaleCapability.
     */
    public static ReadScaleCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReadScaleCapability deserializedReadScaleCapability = new ReadScaleCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxNumberOfReplicas".equals(fieldName)) {
                    deserializedReadScaleCapability.maxNumberOfReplicas = reader.getNullable(JsonReader::getInt);
                } else if ("status".equals(fieldName)) {
                    deserializedReadScaleCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedReadScaleCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReadScaleCapability;
        });
    }
}
