// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The managed server family capability.
 */
@Fluent
public final class ManagedInstanceFamilyCapability implements JsonSerializable<ManagedInstanceFamilyCapability> {
    /*
     * Family name.
     */
    private String name;

    /*
     * SKU name.
     */
    private String sku;

    /*
     * List of supported license types.
     */
    private List<LicenseTypeCapability> supportedLicenseTypes;

    /*
     * List of supported virtual cores values.
     */
    private List<ManagedInstanceVcoresCapability> supportedVcoresValues;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ManagedInstanceFamilyCapability class.
     */
    public ManagedInstanceFamilyCapability() {
    }

    /**
     * Get the name property: Family name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the sku property: SKU name.
     * 
     * @return the sku value.
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Get the supportedLicenseTypes property: List of supported license types.
     * 
     * @return the supportedLicenseTypes value.
     */
    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    /**
     * Get the supportedVcoresValues property: List of supported virtual cores values.
     * 
     * @return the supportedVcoresValues value.
     */
    public List<ManagedInstanceVcoresCapability> supportedVcoresValues() {
        return this.supportedVcoresValues;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ManagedInstanceFamilyCapability object itself.
     */
    public ManagedInstanceFamilyCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedLicenseTypes() != null) {
            supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (supportedVcoresValues() != null) {
            supportedVcoresValues().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedInstanceFamilyCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedInstanceFamilyCapability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedInstanceFamilyCapability.
     */
    public static ManagedInstanceFamilyCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceFamilyCapability deserializedManagedInstanceFamilyCapability
                = new ManagedInstanceFamilyCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceFamilyCapability.name = reader.getString();
                } else if ("sku".equals(fieldName)) {
                    deserializedManagedInstanceFamilyCapability.sku = reader.getString();
                } else if ("supportedLicenseTypes".equals(fieldName)) {
                    List<LicenseTypeCapability> supportedLicenseTypes
                        = reader.readArray(reader1 -> LicenseTypeCapability.fromJson(reader1));
                    deserializedManagedInstanceFamilyCapability.supportedLicenseTypes = supportedLicenseTypes;
                } else if ("supportedVcoresValues".equals(fieldName)) {
                    List<ManagedInstanceVcoresCapability> supportedVcoresValues
                        = reader.readArray(reader1 -> ManagedInstanceVcoresCapability.fromJson(reader1));
                    deserializedManagedInstanceFamilyCapability.supportedVcoresValues = supportedVcoresValues;
                } else if ("status".equals(fieldName)) {
                    deserializedManagedInstanceFamilyCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedManagedInstanceFamilyCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedInstanceFamilyCapability;
        });
    }
}
