// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the information necessary to start a managed database move.
 */
@Fluent
public final class ManagedDatabaseStartMoveDefinition implements JsonSerializable<ManagedDatabaseStartMoveDefinition> {
    /*
     * The destination managed database ID
     */
    private String destinationManagedDatabaseId;

    /*
     * The move operation mode.
     */
    private MoveOperationMode operationMode;

    /**
     * Creates an instance of ManagedDatabaseStartMoveDefinition class.
     */
    public ManagedDatabaseStartMoveDefinition() {
    }

    /**
     * Get the destinationManagedDatabaseId property: The destination managed database ID.
     * 
     * @return the destinationManagedDatabaseId value.
     */
    public String destinationManagedDatabaseId() {
        return this.destinationManagedDatabaseId;
    }

    /**
     * Set the destinationManagedDatabaseId property: The destination managed database ID.
     * 
     * @param destinationManagedDatabaseId the destinationManagedDatabaseId value to set.
     * @return the ManagedDatabaseStartMoveDefinition object itself.
     */
    public ManagedDatabaseStartMoveDefinition withDestinationManagedDatabaseId(String destinationManagedDatabaseId) {
        this.destinationManagedDatabaseId = destinationManagedDatabaseId;
        return this;
    }

    /**
     * Get the operationMode property: The move operation mode.
     * 
     * @return the operationMode value.
     */
    public MoveOperationMode operationMode() {
        return this.operationMode;
    }

    /**
     * Set the operationMode property: The move operation mode.
     * 
     * @param operationMode the operationMode value to set.
     * @return the ManagedDatabaseStartMoveDefinition object itself.
     */
    public ManagedDatabaseStartMoveDefinition withOperationMode(MoveOperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (destinationManagedDatabaseId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationManagedDatabaseId in model ManagedDatabaseStartMoveDefinition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedDatabaseStartMoveDefinition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("destinationManagedDatabaseId", this.destinationManagedDatabaseId);
        jsonWriter.writeStringField("operationMode", this.operationMode == null ? null : this.operationMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedDatabaseStartMoveDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedDatabaseStartMoveDefinition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedDatabaseStartMoveDefinition.
     */
    public static ManagedDatabaseStartMoveDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedDatabaseStartMoveDefinition deserializedManagedDatabaseStartMoveDefinition
                = new ManagedDatabaseStartMoveDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("destinationManagedDatabaseId".equals(fieldName)) {
                    deserializedManagedDatabaseStartMoveDefinition.destinationManagedDatabaseId = reader.getString();
                } else if ("operationMode".equals(fieldName)) {
                    deserializedManagedDatabaseStartMoveDefinition.operationMode
                        = MoveOperationMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedDatabaseStartMoveDefinition;
        });
    }
}
