// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SyncAgentState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Properties of an Azure SQL Database sync agent.
 */
@Fluent
public final class SyncAgentProperties implements JsonSerializable<SyncAgentProperties> {
    /*
     * Name of the sync agent.
     */
    private String name;

    /*
     * ARM resource id of the sync database in the sync agent.
     */
    private String syncDatabaseId;

    /*
     * Last alive time of the sync agent.
     */
    private OffsetDateTime lastAliveTime;

    /*
     * State of the sync agent.
     */
    private SyncAgentState state;

    /*
     * If the sync agent version is up to date.
     */
    private Boolean isUpToDate;

    /*
     * Expiration time of the sync agent version.
     */
    private OffsetDateTime expiryTime;

    /*
     * Version of the sync agent.
     */
    private String version;

    /**
     * Creates an instance of SyncAgentProperties class.
     */
    public SyncAgentProperties() {
    }

    /**
     * Get the name property: Name of the sync agent.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the syncDatabaseId property: ARM resource id of the sync database in the sync agent.
     * 
     * @return the syncDatabaseId value.
     */
    public String syncDatabaseId() {
        return this.syncDatabaseId;
    }

    /**
     * Set the syncDatabaseId property: ARM resource id of the sync database in the sync agent.
     * 
     * @param syncDatabaseId the syncDatabaseId value to set.
     * @return the SyncAgentProperties object itself.
     */
    public SyncAgentProperties withSyncDatabaseId(String syncDatabaseId) {
        this.syncDatabaseId = syncDatabaseId;
        return this;
    }

    /**
     * Get the lastAliveTime property: Last alive time of the sync agent.
     * 
     * @return the lastAliveTime value.
     */
    public OffsetDateTime lastAliveTime() {
        return this.lastAliveTime;
    }

    /**
     * Get the state property: State of the sync agent.
     * 
     * @return the state value.
     */
    public SyncAgentState state() {
        return this.state;
    }

    /**
     * Get the isUpToDate property: If the sync agent version is up to date.
     * 
     * @return the isUpToDate value.
     */
    public Boolean isUpToDate() {
        return this.isUpToDate;
    }

    /**
     * Get the expiryTime property: Expiration time of the sync agent version.
     * 
     * @return the expiryTime value.
     */
    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    /**
     * Get the version property: Version of the sync agent.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("syncDatabaseId", this.syncDatabaseId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SyncAgentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SyncAgentProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SyncAgentProperties.
     */
    public static SyncAgentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncAgentProperties deserializedSyncAgentProperties = new SyncAgentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSyncAgentProperties.name = reader.getString();
                } else if ("syncDatabaseId".equals(fieldName)) {
                    deserializedSyncAgentProperties.syncDatabaseId = reader.getString();
                } else if ("lastAliveTime".equals(fieldName)) {
                    deserializedSyncAgentProperties.lastAliveTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("state".equals(fieldName)) {
                    deserializedSyncAgentProperties.state = SyncAgentState.fromString(reader.getString());
                } else if ("isUpToDate".equals(fieldName)) {
                    deserializedSyncAgentProperties.isUpToDate = reader.getNullable(JsonReader::getBoolean);
                } else if ("expiryTime".equals(fieldName)) {
                    deserializedSyncAgentProperties.expiryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("version".equals(fieldName)) {
                    deserializedSyncAgentProperties.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSyncAgentProperties;
        });
    }
}
