/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.JobStepOutputType;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class JobStepOutput
implements JsonSerializable<JobStepOutput> {
    private JobStepOutputType type;
    private UUID subscriptionId;
    private String resourceGroupName;
    private String serverName;
    private String databaseName;
    private String schemaName;
    private String tableName;
    private String credential;
    private static final ClientLogger LOGGER = new ClientLogger(JobStepOutput.class);

    public JobStepOutputType type() {
        return this.type;
    }

    public JobStepOutput withType(JobStepOutputType type) {
        this.type = type;
        return this;
    }

    public UUID subscriptionId() {
        return this.subscriptionId;
    }

    public JobStepOutput withSubscriptionId(UUID subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public JobStepOutput withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public JobStepOutput withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public JobStepOutput withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public JobStepOutput withSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public JobStepOutput withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String credential() {
        return this.credential;
    }

    public JobStepOutput withCredential(String credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.serverName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverName in model JobStepOutput"));
        }
        if (this.databaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model JobStepOutput"));
        }
        if (this.tableName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tableName in model JobStepOutput"));
        }
        if (this.credential() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property credential in model JobStepOutput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeStringField("credential", this.credential);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("subscriptionId", Objects.toString(this.subscriptionId, null));
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("schemaName", this.schemaName);
        return jsonWriter.writeEndObject();
    }

    public static JobStepOutput fromJson(JsonReader jsonReader) throws IOException {
        return (JobStepOutput)jsonReader.readObject(reader -> {
            JobStepOutput deserializedJobStepOutput = new JobStepOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverName".equals(fieldName)) {
                    deserializedJobStepOutput.serverName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedJobStepOutput.databaseName = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedJobStepOutput.tableName = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedJobStepOutput.credential = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobStepOutput.type = JobStepOutputType.fromString(reader.getString());
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedJobStepOutput.subscriptionId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedJobStepOutput.resourceGroupName = reader.getString();
                    continue;
                }
                if ("schemaName".equals(fieldName)) {
                    deserializedJobStepOutput.schemaName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStepOutput;
        });
    }
}

