// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The differential backup interval in hours. This is how many interval hours between each differential backup will be
 * supported. This is only applicable to live databases but not dropped databases.
 */
public final class DiffBackupIntervalInHours extends ExpandableStringEnum<DiffBackupIntervalInHours> {
    /**
     * Static value 12 for DiffBackupIntervalInHours.
     */
    public static final DiffBackupIntervalInHours ONE_TWO = fromInt(12);

    /**
     * Static value 24 for DiffBackupIntervalInHours.
     */
    public static final DiffBackupIntervalInHours TWO_FOUR = fromInt(24);

    /**
     * Creates a new instance of DiffBackupIntervalInHours value.
     * 
     * @deprecated Use the {@link #fromInt(int)} factory method.
     */
    @Deprecated
    public DiffBackupIntervalInHours() {
    }

    /**
     * Creates or finds a DiffBackupIntervalInHours from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DiffBackupIntervalInHours.
     */
    public static DiffBackupIntervalInHours fromInt(int name) {
        return fromString(String.valueOf(name), DiffBackupIntervalInHours.class);
    }

    /**
     * Gets known DiffBackupIntervalInHours values.
     * 
     * @return known DiffBackupIntervalInHours values.
     */
    public static Collection<DiffBackupIntervalInHours> values() {
        return values(DiffBackupIntervalInHours.class);
    }
}
