// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.MaintenanceWindowTimeRange;
import java.io.IOException;
import java.util.List;

/**
 * Maintenance windows resource properties.
 */
@Fluent
public final class MaintenanceWindowsProperties implements JsonSerializable<MaintenanceWindowsProperties> {
    /*
     * The timeRanges property.
     */
    private List<MaintenanceWindowTimeRange> timeRanges;

    /**
     * Creates an instance of MaintenanceWindowsProperties class.
     */
    public MaintenanceWindowsProperties() {
    }

    /**
     * Get the timeRanges property: The timeRanges property.
     * 
     * @return the timeRanges value.
     */
    public List<MaintenanceWindowTimeRange> timeRanges() {
        return this.timeRanges;
    }

    /**
     * Set the timeRanges property: The timeRanges property.
     * 
     * @param timeRanges the timeRanges value to set.
     * @return the MaintenanceWindowsProperties object itself.
     */
    public MaintenanceWindowsProperties withTimeRanges(List<MaintenanceWindowTimeRange> timeRanges) {
        this.timeRanges = timeRanges;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timeRanges() != null) {
            timeRanges().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("timeRanges", this.timeRanges, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaintenanceWindowsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaintenanceWindowsProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MaintenanceWindowsProperties.
     */
    public static MaintenanceWindowsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaintenanceWindowsProperties deserializedMaintenanceWindowsProperties = new MaintenanceWindowsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timeRanges".equals(fieldName)) {
                    List<MaintenanceWindowTimeRange> timeRanges
                        = reader.readArray(reader1 -> MaintenanceWindowTimeRange.fromJson(reader1));
                    deserializedMaintenanceWindowsProperties.timeRanges = timeRanges;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaintenanceWindowsProperties;
        });
    }
}
