// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.LedgerDigestUploadsState;
import java.io.IOException;

/**
 * Azure SQL Database ledger digest upload settings.
 */
@Fluent
public final class LedgerDigestUploadsInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private LedgerDigestUploadsProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of LedgerDigestUploadsInner class.
     */
    public LedgerDigestUploadsInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private LedgerDigestUploadsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the digestStorageEndpoint property: The digest storage endpoint, which must be either an Azure blob storage
     * endpoint or an URI for Azure Confidential Ledger.
     * 
     * @return the digestStorageEndpoint value.
     */
    public String digestStorageEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().digestStorageEndpoint();
    }

    /**
     * Set the digestStorageEndpoint property: The digest storage endpoint, which must be either an Azure blob storage
     * endpoint or an URI for Azure Confidential Ledger.
     * 
     * @param digestStorageEndpoint the digestStorageEndpoint value to set.
     * @return the LedgerDigestUploadsInner object itself.
     */
    public LedgerDigestUploadsInner withDigestStorageEndpoint(String digestStorageEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LedgerDigestUploadsProperties();
        }
        this.innerProperties().withDigestStorageEndpoint(digestStorageEndpoint);
        return this;
    }

    /**
     * Get the state property: Specifies the state of ledger digest upload.
     * 
     * @return the state value.
     */
    public LedgerDigestUploadsState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LedgerDigestUploadsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LedgerDigestUploadsInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LedgerDigestUploadsInner.
     */
    public static LedgerDigestUploadsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LedgerDigestUploadsInner deserializedLedgerDigestUploadsInner = new LedgerDigestUploadsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLedgerDigestUploadsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLedgerDigestUploadsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLedgerDigestUploadsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLedgerDigestUploadsInner.innerProperties
                        = LedgerDigestUploadsProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLedgerDigestUploadsInner;
        });
    }
}
