// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A database Vulnerability Assessment scan export resource.
 */
@Immutable
public final class DatabaseVulnerabilityAssessmentScansExportInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private DatabaseVulnerabilityAssessmentScanExportProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of DatabaseVulnerabilityAssessmentScansExportInner class.
     */
    public DatabaseVulnerabilityAssessmentScansExportInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private DatabaseVulnerabilityAssessmentScanExportProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the exportedReportLocation property: Location of the exported report (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
     * 
     * @return the exportedReportLocation value.
     */
    public String exportedReportLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().exportedReportLocation();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseVulnerabilityAssessmentScansExportInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseVulnerabilityAssessmentScansExportInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DatabaseVulnerabilityAssessmentScansExportInner.
     */
    public static DatabaseVulnerabilityAssessmentScansExportInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseVulnerabilityAssessmentScansExportInner deserializedDatabaseVulnerabilityAssessmentScansExportInner
                = new DatabaseVulnerabilityAssessmentScansExportInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentScansExportInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentScansExportInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentScansExportInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDatabaseVulnerabilityAssessmentScansExportInner.innerProperties
                        = DatabaseVulnerabilityAssessmentScanExportProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseVulnerabilityAssessmentScansExportInner;
        });
    }
}
