/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.EncryptionProtectorProperties;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;

public final class EncryptionProtectorInner
extends ProxyResource {
    private String kind;
    private String location;
    private EncryptionProtectorProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String kind() {
        return this.kind;
    }

    public String location() {
        return this.location;
    }

    private EncryptionProtectorProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String subregion() {
        return this.innerProperties() == null ? null : this.innerProperties().subregion();
    }

    public String serverKeyName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverKeyName();
    }

    public EncryptionProtectorInner withServerKeyName(String serverKeyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionProtectorProperties();
        }
        this.innerProperties().withServerKeyName(serverKeyName);
        return this;
    }

    public ServerKeyType serverKeyType() {
        return this.innerProperties() == null ? null : this.innerProperties().serverKeyType();
    }

    public EncryptionProtectorInner withServerKeyType(ServerKeyType serverKeyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionProtectorProperties();
        }
        this.innerProperties().withServerKeyType(serverKeyType);
        return this;
    }

    public String uri() {
        return this.innerProperties() == null ? null : this.innerProperties().uri();
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public Boolean autoRotationEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().autoRotationEnabled();
    }

    public EncryptionProtectorInner withAutoRotationEnabled(Boolean autoRotationEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionProtectorProperties();
        }
        this.innerProperties().withAutoRotationEnabled(autoRotationEnabled);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionProtectorInner fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionProtectorInner)((Object)jsonReader.readObject(reader -> {
            EncryptionProtectorInner deserializedEncryptionProtectorInner = new EncryptionProtectorInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEncryptionProtectorInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEncryptionProtectorInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEncryptionProtectorInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedEncryptionProtectorInner.kind = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedEncryptionProtectorInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEncryptionProtectorInner.innerProperties = EncryptionProtectorProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionProtectorInner;
        }));
    }
}

