// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The storage account type capability.
 */
@Fluent
public final class StorageCapability implements JsonSerializable<StorageCapability> {
    /*
     * The storage account type for the database's backups.
     */
    private StorageCapabilityStorageAccountType storageAccountType;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of StorageCapability class.
     */
    public StorageCapability() {
    }

    /**
     * Get the storageAccountType property: The storage account type for the database's backups.
     * 
     * @return the storageAccountType value.
     */
    public StorageCapabilityStorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the StorageCapability object itself.
     */
    public StorageCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageCapability if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageCapability.
     */
    public static StorageCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageCapability deserializedStorageCapability = new StorageCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountType".equals(fieldName)) {
                    deserializedStorageCapability.storageAccountType
                        = StorageCapabilityStorageAccountType.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedStorageCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedStorageCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageCapability;
        });
    }
}
