// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

/**
 * The service objectives capability.
 */
@Fluent
public final class ServiceObjectiveCapability implements JsonSerializable<ServiceObjectiveCapability> {
    /*
     * The unique ID of the service objective.
     */
    private UUID id;

    /*
     * The service objective name.
     */
    private String name;

    /*
     * The list of supported maximum database sizes.
     */
    private List<MaxSizeRangeCapability> supportedMaxSizes;

    /*
     * The performance level.
     */
    private PerformanceLevelCapability performanceLevel;

    /*
     * The sku.
     */
    private Sku sku;

    /*
     * List of supported license types.
     */
    private List<LicenseTypeCapability> supportedLicenseTypes;

    /*
     * The included (free) max size.
     */
    private MaxSizeCapability includedMaxSize;

    /*
     * Whether or not zone redundancy is supported for the service objective.
     */
    private Boolean zoneRedundant;

    /*
     * Supported time range for auto pause delay
     */
    private AutoPauseDelayTimeRange supportedAutoPauseDelay;

    /*
     * List of supported min capacities
     */
    private List<MinCapacityCapability> supportedMinCapacities;

    /*
     * The compute model
     */
    private String computeModel;

    /*
     * List of supported maintenance configurations
     */
    private List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /**
     * Creates an instance of ServiceObjectiveCapability class.
     */
    public ServiceObjectiveCapability() {
    }

    /**
     * Get the id property: The unique ID of the service objective.
     * 
     * @return the id value.
     */
    public UUID id() {
        return this.id;
    }

    /**
     * Get the name property: The service objective name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the supportedMaxSizes property: The list of supported maximum database sizes.
     * 
     * @return the supportedMaxSizes value.
     */
    public List<MaxSizeRangeCapability> supportedMaxSizes() {
        return this.supportedMaxSizes;
    }

    /**
     * Get the performanceLevel property: The performance level.
     * 
     * @return the performanceLevel value.
     */
    public PerformanceLevelCapability performanceLevel() {
        return this.performanceLevel;
    }

    /**
     * Get the sku property: The sku.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Get the supportedLicenseTypes property: List of supported license types.
     * 
     * @return the supportedLicenseTypes value.
     */
    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    /**
     * Get the includedMaxSize property: The included (free) max size.
     * 
     * @return the includedMaxSize value.
     */
    public MaxSizeCapability includedMaxSize() {
        return this.includedMaxSize;
    }

    /**
     * Get the zoneRedundant property: Whether or not zone redundancy is supported for the service objective.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the supportedAutoPauseDelay property: Supported time range for auto pause delay.
     * 
     * @return the supportedAutoPauseDelay value.
     */
    public AutoPauseDelayTimeRange supportedAutoPauseDelay() {
        return this.supportedAutoPauseDelay;
    }

    /**
     * Get the supportedMinCapacities property: List of supported min capacities.
     * 
     * @return the supportedMinCapacities value.
     */
    public List<MinCapacityCapability> supportedMinCapacities() {
        return this.supportedMinCapacities;
    }

    /**
     * Get the computeModel property: The compute model.
     * 
     * @return the computeModel value.
     */
    public String computeModel() {
        return this.computeModel;
    }

    /**
     * Get the supportedMaintenanceConfigurations property: List of supported maintenance configurations.
     * 
     * @return the supportedMaintenanceConfigurations value.
     */
    public List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations() {
        return this.supportedMaintenanceConfigurations;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for the capability not being available.
     * 
     * @param reason the reason value to set.
     * @return the ServiceObjectiveCapability object itself.
     */
    public ServiceObjectiveCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportedMaxSizes() != null) {
            supportedMaxSizes().forEach(e -> e.validate());
        }
        if (performanceLevel() != null) {
            performanceLevel().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
        if (supportedLicenseTypes() != null) {
            supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (includedMaxSize() != null) {
            includedMaxSize().validate();
        }
        if (supportedAutoPauseDelay() != null) {
            supportedAutoPauseDelay().validate();
        }
        if (supportedMinCapacities() != null) {
            supportedMinCapacities().forEach(e -> e.validate());
        }
        if (supportedMaintenanceConfigurations() != null) {
            supportedMaintenanceConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceObjectiveCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceObjectiveCapability if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceObjectiveCapability.
     */
    public static ServiceObjectiveCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceObjectiveCapability deserializedServiceObjectiveCapability = new ServiceObjectiveCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.id
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("name".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.name = reader.getString();
                } else if ("supportedMaxSizes".equals(fieldName)) {
                    List<MaxSizeRangeCapability> supportedMaxSizes
                        = reader.readArray(reader1 -> MaxSizeRangeCapability.fromJson(reader1));
                    deserializedServiceObjectiveCapability.supportedMaxSizes = supportedMaxSizes;
                } else if ("performanceLevel".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.performanceLevel
                        = PerformanceLevelCapability.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.sku = Sku.fromJson(reader);
                } else if ("supportedLicenseTypes".equals(fieldName)) {
                    List<LicenseTypeCapability> supportedLicenseTypes
                        = reader.readArray(reader1 -> LicenseTypeCapability.fromJson(reader1));
                    deserializedServiceObjectiveCapability.supportedLicenseTypes = supportedLicenseTypes;
                } else if ("includedMaxSize".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.includedMaxSize = MaxSizeCapability.fromJson(reader);
                } else if ("zoneRedundant".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.zoneRedundant = reader.getNullable(JsonReader::getBoolean);
                } else if ("supportedAutoPauseDelay".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.supportedAutoPauseDelay
                        = AutoPauseDelayTimeRange.fromJson(reader);
                } else if ("supportedMinCapacities".equals(fieldName)) {
                    List<MinCapacityCapability> supportedMinCapacities
                        = reader.readArray(reader1 -> MinCapacityCapability.fromJson(reader1));
                    deserializedServiceObjectiveCapability.supportedMinCapacities = supportedMinCapacities;
                } else if ("computeModel".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.computeModel = reader.getString();
                } else if ("supportedMaintenanceConfigurations".equals(fieldName)) {
                    List<MaintenanceConfigurationCapability> supportedMaintenanceConfigurations
                        = reader.readArray(reader1 -> MaintenanceConfigurationCapability.fromJson(reader1));
                    deserializedServiceObjectiveCapability.supportedMaintenanceConfigurations
                        = supportedMaintenanceConfigurations;
                } else if ("status".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.status = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedServiceObjectiveCapability.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceObjectiveCapability;
        });
    }
}
