// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.PrivateEndpointConnectionProperties;
import java.io.IOException;

/**
 * A private endpoint connection under a server.
 */
@Immutable
public final class ServerPrivateEndpointConnection implements JsonSerializable<ServerPrivateEndpointConnection> {
    /*
     * Resource ID.
     */
    private String id;

    /*
     * Private endpoint connection properties
     */
    private PrivateEndpointConnectionProperties properties;

    /**
     * Creates an instance of ServerPrivateEndpointConnection class.
     */
    public ServerPrivateEndpointConnection() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the properties property: Private endpoint connection properties.
     * 
     * @return the properties value.
     */
    public PrivateEndpointConnectionProperties properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerPrivateEndpointConnection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerPrivateEndpointConnection if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerPrivateEndpointConnection.
     */
    public static ServerPrivateEndpointConnection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerPrivateEndpointConnection deserializedServerPrivateEndpointConnection
                = new ServerPrivateEndpointConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerPrivateEndpointConnection.id = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerPrivateEndpointConnection.properties
                        = PrivateEndpointConnectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerPrivateEndpointConnection;
        });
    }
}
