// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A server dns alias acquisition request.
 */
@Fluent
public final class ServerDnsAliasAcquisition implements JsonSerializable<ServerDnsAliasAcquisition> {
    /*
     * The id of the server alias that will be acquired to point to this server instead.
     */
    private String oldServerDnsAliasId;

    /**
     * Creates an instance of ServerDnsAliasAcquisition class.
     */
    public ServerDnsAliasAcquisition() {
    }

    /**
     * Get the oldServerDnsAliasId property: The id of the server alias that will be acquired to point to this server
     * instead.
     * 
     * @return the oldServerDnsAliasId value.
     */
    public String oldServerDnsAliasId() {
        return this.oldServerDnsAliasId;
    }

    /**
     * Set the oldServerDnsAliasId property: The id of the server alias that will be acquired to point to this server
     * instead.
     * 
     * @param oldServerDnsAliasId the oldServerDnsAliasId value to set.
     * @return the ServerDnsAliasAcquisition object itself.
     */
    public ServerDnsAliasAcquisition withOldServerDnsAliasId(String oldServerDnsAliasId) {
        this.oldServerDnsAliasId = oldServerDnsAliasId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (oldServerDnsAliasId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property oldServerDnsAliasId in model ServerDnsAliasAcquisition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ServerDnsAliasAcquisition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("oldServerDnsAliasId", this.oldServerDnsAliasId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerDnsAliasAcquisition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerDnsAliasAcquisition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerDnsAliasAcquisition.
     */
    public static ServerDnsAliasAcquisition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerDnsAliasAcquisition deserializedServerDnsAliasAcquisition = new ServerDnsAliasAcquisition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("oldServerDnsAliasId".equals(fieldName)) {
                    deserializedServerDnsAliasAcquisition.oldServerDnsAliasId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerDnsAliasAcquisition;
        });
    }
}
