// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains information for manual implementation for an Azure SQL Database, Server or Elastic Pool Recommended Action.
 */
@Immutable
public final class RecommendedActionImplementationInfo
    implements JsonSerializable<RecommendedActionImplementationInfo> {
    /*
     * Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell.
     */
    private ImplementationMethod method;

    /*
     * Gets the manual implementation script. e.g., T-SQL script that could be executed on the database.
     */
    private String script;

    /**
     * Creates an instance of RecommendedActionImplementationInfo class.
     */
    public RecommendedActionImplementationInfo() {
    }

    /**
     * Get the method property: Gets the method in which this recommended action can be manually implemented. e.g.,
     * TSql, AzurePowerShell.
     * 
     * @return the method value.
     */
    public ImplementationMethod method() {
        return this.method;
    }

    /**
     * Get the script property: Gets the manual implementation script. e.g., T-SQL script that could be executed on the
     * database.
     * 
     * @return the script value.
     */
    public String script() {
        return this.script;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendedActionImplementationInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendedActionImplementationInfo if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecommendedActionImplementationInfo.
     */
    public static RecommendedActionImplementationInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendedActionImplementationInfo deserializedRecommendedActionImplementationInfo
                = new RecommendedActionImplementationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("method".equals(fieldName)) {
                    deserializedRecommendedActionImplementationInfo.method
                        = ImplementationMethod.fromString(reader.getString());
                } else if ("script".equals(fieldName)) {
                    deserializedRecommendedActionImplementationInfo.script = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendedActionImplementationInfo;
        });
    }
}
