// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of a query metrics interval.
 */
@Fluent
public final class QueryMetricInterval implements JsonSerializable<QueryMetricInterval> {
    /*
     * The start time for the metric interval (ISO-8601 format).
     */
    private String intervalStartTime;

    /*
     * Interval type (length).
     */
    private QueryTimeGrainType intervalType;

    /*
     * Execution count of a query in this interval.
     */
    private Long executionCount;

    /*
     * List of metric objects for this interval
     */
    private List<QueryMetricProperties> metrics;

    /**
     * Creates an instance of QueryMetricInterval class.
     */
    public QueryMetricInterval() {
    }

    /**
     * Get the intervalStartTime property: The start time for the metric interval (ISO-8601 format).
     * 
     * @return the intervalStartTime value.
     */
    public String intervalStartTime() {
        return this.intervalStartTime;
    }

    /**
     * Get the intervalType property: Interval type (length).
     * 
     * @return the intervalType value.
     */
    public QueryTimeGrainType intervalType() {
        return this.intervalType;
    }

    /**
     * Get the executionCount property: Execution count of a query in this interval.
     * 
     * @return the executionCount value.
     */
    public Long executionCount() {
        return this.executionCount;
    }

    /**
     * Get the metrics property: List of metric objects for this interval.
     * 
     * @return the metrics value.
     */
    public List<QueryMetricProperties> metrics() {
        return this.metrics;
    }

    /**
     * Set the metrics property: List of metric objects for this interval.
     * 
     * @param metrics the metrics value to set.
     * @return the QueryMetricInterval object itself.
     */
    public QueryMetricInterval withMetrics(List<QueryMetricProperties> metrics) {
        this.metrics = metrics;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metrics() != null) {
            metrics().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("metrics", this.metrics, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryMetricInterval from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryMetricInterval if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryMetricInterval.
     */
    public static QueryMetricInterval fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryMetricInterval deserializedQueryMetricInterval = new QueryMetricInterval();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("intervalStartTime".equals(fieldName)) {
                    deserializedQueryMetricInterval.intervalStartTime = reader.getString();
                } else if ("intervalType".equals(fieldName)) {
                    deserializedQueryMetricInterval.intervalType = QueryTimeGrainType.fromString(reader.getString());
                } else if ("executionCount".equals(fieldName)) {
                    deserializedQueryMetricInterval.executionCount = reader.getNullable(JsonReader::getLong);
                } else if ("metrics".equals(fieldName)) {
                    List<QueryMetricProperties> metrics
                        = reader.readArray(reader1 -> QueryMetricProperties.fromJson(reader1));
                    deserializedQueryMetricInterval.metrics = metrics;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryMetricInterval;
        });
    }
}
